/***************************************************************/
//
//
//		DirectX	[ camera.cpp ]
//
//											Author	kazuki tanaka
//											Date	2016 10/24
/*---------------------------------------------------------------
Update : 2016/10/24
			camera.cpp̍쐬

/*---------------------------------------------------------------
	CN[ht@C
---------------------------------------------------------------*/

#include "main.h"
#include "camera.h"

#include "input.h"
#include "mouse.h"

//#include <Windows.h>
//#include <stdio.h>
//#include <d3dx9.h>

//#pragma comment (lib,"d3d9.lib")
//#pragma comment (lib,"d3dx9.lib")
//#pragma comment (lib,"dxguid.lib")


/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define SAFE_RELEASE(p) { if (p) { (p)->Release(); (p)=NULL; } }
#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

// AtBϊ
#define AFFINE_TRANSFORM_X( radiusX, radiusY, theta ) \
(( radiusX ) * cosf( RADIAN( theta )) - ( radiusY ) * sinf( RADIAN( theta )))

#define AFFINE_TRANSFORM_Y( radiusX, radiusY, theta ) \
(( radiusX ) * sinf( RADIAN( theta )) + ( radiusY ) * cosf( RADIAN( theta )))

#define LIMIT_MAX(a,b) ( a>b ? b : a )				// ől̐ݒ( ႢlԂ )
#define LIMIT_MIM(a,b) ( a>b ? a : b )				// ŏl̐ݒ( lԂ )

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/


/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/


/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

D3DXVECTOR3 g_posCamera;
D3DXVECTOR3 g_posAt;
D3DXVECTOR3 g_vecUp;
float       g_fFov;

D3DXMATRIX mtxViewInverse;


D3DXVECTOR3 posEye( g_posCamera.x, g_posCamera.y, g_posCamera.z );
D3DXVECTOR3 posAt ( g_posAt.x, g_posAt.y, g_posAt.z );
D3DXVECTOR3 vecUp ( g_vecUp.x, g_vecUp.y, g_vecUp.z );


D3DXVECTOR3 translateMove;
float cameraToAt = 50.0f;

static D3DXVECTOR3 rotation;

static bool cameraUse = true;


// CAMERȀ
void InitCamera( void )
{

	// J̏
	g_posCamera = D3DXVECTOR3( 0, 25,-cameraToAt );
	g_posAt     = D3DXVECTOR3( 0,0,0 );
	g_vecUp     = D3DXVECTOR3( 0,1.0f, 0 );
	g_fFov      = 60.0f;

	cameraToAt = 50.0f;

	rotation.x  = 90.0f;
	rotation.y  = -90.0f;
	rotation.z  = 0.0f;

	translateMove = D3DXVECTOR3( 0,0,0 );

	posEye = D3DXVECTOR3( 0, 12.0f, -cameraToAt );
	//posEye = D3DXVECTOR3( 0, -25.0f, 10 );
	posAt  = D3DXVECTOR3( 0, 0, 0 );
	vecUp  = D3DXVECTOR3( 0, 1.0f, 0 );

	// J̑tȌ
	cameraUse = true;


}

// CAMERȀI
void UninitCamera( void )
{


	
}

// CAMERA̍XV
void UpdateCamera( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	// r[s̍쐬
	D3DXMATRIX viewMtx;


	if( GetMouseZ( ) != 0 ){

		D3DXVECTOR3 vector = posAt - posEye;
		vector.y = 0.0f;

		// J̌PʃxNg
		D3DXVec3Normalize( &vector, &vector );

		posEye += vector * GetMouseZ( )*1.5f;
		posAt  += vector * GetMouseZ( )*1.5f;

	}

	// _̉] 
	if( GetMousePress( MOUSE_BUTTON_RIGHT )){

		if( GetMouseDefX( ) ){

			D3DXVECTOR3 length = posEye - posAt;
			float theta = atan2f( length.z, length.x );

			theta += GetMouseDefX( )*0.01f;

			posEye.x = cosf( theta ) * cameraToAt + posAt.x;
			posEye.z = sinf( theta ) * cameraToAt + posAt.z;
		}
		if( GetMouseDefY( ) ){
			
			D3DXVECTOR3 length = posEye - posAt;
			float theta = atan2f( length.z, length.y );

			theta -= GetMouseDefY( )*0.01f;

			posEye.y = cosf( theta ) * cameraToAt + posAt.x;
			posEye.z = sinf( theta ) * cameraToAt + posAt.z;
		}
	}

	// r[̍XV
	if( cameraUse ){

		// Y[C&Y[AEg
		if( GetKeyboardPress( DIK_Z ) ){
			g_fFov++;
		}
		if( GetKeyboardPress( DIK_X ) ){
			g_fFov--;
		}

		// _̉] 
		if( GetKeyboardPress( DIK_LEFT )){
			//rotation.y++;

			D3DXVECTOR3 length = posEye - posAt;

			float angle = atan2f( length.z, length.x );
			//static float angle = 0;
			angle += 0.1f;

			posEye.x = cosf( angle ) * 50 + posAt.x;
			posEye.z = sinf( angle ) * 50 + posAt.z;

		}
		if( GetKeyboardPress( DIK_RIGHT )){
			//rotation.y--;

			D3DXVECTOR3 length = posEye - posAt;

			float angle = atan2f( length.z, length.x );
			//static float angle = 0;
			angle -= 0.1f;

			posEye.x = cosf( angle ) * 50 + posAt.x;
			posEye.z = sinf( angle ) * 50 + posAt.z;

		}

		if( GetKeyboardPress( DIK_UP )){
			//rotation.y++;

			D3DXVECTOR3 length = posEye - posAt;

			float angle = atan2f( length.z, length.y );
			//static float angle = 0;
			angle -= 0.005f;

			angle = LIMIT_MAX( angle, D3DX_PI*0.5f-0.1f );

			posEye.y = cosf( angle ) * 50 + posAt.x;
			posEye.z = sinf( angle ) * 50 + posAt.z;

			//vecUp.y = vecUp.y * sinf( angle );

		}
		if( GetKeyboardPress( DIK_DOWN )){
			//rotation.y--;

			D3DXVECTOR3 length = posEye - posAt;

			float angle = atan2f( length.z, length.y );
			//static float angle = 0;
			angle += 0.005f;
			
			angle = LIMIT_MIM( angle, -D3DX_PI*0.5f+0.1f );

			posEye.y = cosf( angle ) * 50 + posAt.x;
			posEye.z = sinf( angle ) * 50 + posAt.z;

			//vecUp.y = vecUp.y * sinf( angle );

		}

		// J̉]
		if( GetKeyboardPress( DIK_O )){
			//rotation.x++;

			D3DXVECTOR3 length = posAt - posEye;

			float angle = atan2f( length.z, length.x );
			//static float angle = 0;
			angle += 0.1f;

			posAt.x = cosf( angle ) * 50 + posEye.x;
			posAt.z = sinf( angle ) * 50 + posEye.z;

		}
		if( GetKeyboardPress( DIK_P )){
			//rotation.x--;

			D3DXVECTOR3 length = posAt - posEye;

			float angle = atan2f( length.z, length.x );
			//static float angle = 0;
			angle -= 0.1f;

			posAt.x = cosf( angle ) * 50 + posEye.x;
			posAt.z = sinf( angle ) * 50 + posEye.z;

		}

		// J̕sړ
		if( GetKeyboardPress( DIK_W )){
			//translateMove.x++;

			D3DXVECTOR3 vector = posAt - posEye;
			vector.y = 0.0f;

			// J̌PʃxNg
			D3DXVec3Normalize( &vector, &vector );

			posEye += vector * 1.0f;
			posAt  += vector * 1.0f;

		}
		if( GetKeyboardPress( DIK_D )){
			//translateMove.x--;

			D3DXVECTOR3 vector = posAt - posEye;
			vector.y = 0.0f;

			// J̌PʃxNg
			D3DXVec3Normalize( &vector, &vector );

			// ݂̌y=xɑ΂đΏ̂ȃxNgɕϊ
			D3DXVECTOR3 inverseVector( vector.z, vector.y, -vector.x );

			posEye += inverseVector * 1.0f;
			posAt  += inverseVector * 1.0f;

		}
		if( GetKeyboardPress( DIK_A )){
			//translateMove.z++;

			D3DXVECTOR3 vector = posAt - posEye;
			vector.y = 0.0f;

			// J̌PʃxNg
			D3DXVec3Normalize( &vector, &vector );

			// ݂̌y=xɑ΂đΏ̂ȃxNgɕϊ
			D3DXVECTOR3 inverseVector( vector.z, vector.y, -vector.x );

			posEye -= inverseVector * 1.0f;
			posAt  -= inverseVector * 1.0f;

		}
		if( GetKeyboardPress( DIK_S )){
			//translateMove.z--;

			D3DXVECTOR3 vector = posAt - posEye;
			vector.y = 0.0f;

			// J̌PʃxNg
			D3DXVec3Normalize( &vector, &vector );

			posEye -= vector * 1.0f;
			posAt  -= vector * 1.0f;
		}
	}

	// ON/OFFtO؂ւ
	if( GetKeyboardTrigger( DIK_F1 ) ){
	
		if( cameraUse ){
			cameraUse = false;
		}
		else if( !cameraUse ){
			cameraUse = true;
		}
	}

	//D3DXMatrixRotationYawPitchRoll( &viewMtx, D3DXToRadian( rotation.y ), D3DXToRadian( rotation.x ), 0.0f );

	//float angle = atan2f( posAt.z - posEye.z, posAt.x - posEye.x );

	//posEye = D3DXVECTOR3( (cameraToAt*2) * cosf( D3DXToRadian( rotation.x ))+(translateMove.x), 25.0f+translateMove.y, (cameraToAt*2) * sinf( D3DXToRadian( rotation.x ))+(translateMove.z)- (cameraToAt*2) );
	//posEye = D3DXVECTOR3( AFFINE_TRANSFORM_X(cameraToAt,cameraToAt,rotation.x)+(translateMove.x*cos(angle)), 25.0f+translateMove.y, AFFINE_TRANSFORM_Y(cameraToAt,cameraToAt,rotation.x)+(translateMove.z*sinf(angle)) );
	//posAt  = D3DXVECTOR3( posEye.x + cameraToAt * cosf( D3DXToRadian( rotation.y )), 0.0f,  posEye.z + cameraToAt * sinf( D3DXToRadian( rotation.y )) );
	//posAt = D3DXVECTOR3( posAt.x + cameraToAt * cosf( D3DXToRadian( rotation.y )), posAt.y + 0.0f,  posAt.z + cameraToAt * sinf( D3DXToRadian( rotation.y )) );

	//posAt  = D3DXVECTOR3( cameraToAt*2 * cosf( D3DXToRadian( rotation.y )), 0.0f, cameraToAt*2 * sinf( D3DXToRadian( rotation.y )) );

	//posEye = translateMove;
	//posAt  = translateMove;


	// r[s̕ϊ
	D3DXMatrixLookAtLH( &viewMtx, &posEye, &posAt, &vecUp );

	// foCXɃr[ϊs̐ݒ
	pDevice ->SetTransform( D3DTS_VIEW, &viewMtx );

	{ // BIllboardps̍XV
	
		// ts̍쐬
		D3DXMatrixInverse( &mtxViewInverse, NULL, &viewMtx );
	
		// s̏
		mtxViewInverse._41 = 0.0f;
		mtxViewInverse._42 = 0.0f;
		mtxViewInverse._43 = 0.0f;

	} // -> END


	// vWFNVs̍쐬
	D3DXMATRIX mtxProj;
	
	const float ASPECT = (float)SCREEN_WIDTH/SCREEN_HEIGHT;

	// vWFNVs̕ϊ
	D3DXMatrixPerspectiveFovLH( &mtxProj,	 
		D3DXToRadian(g_fFov),//D3DX_PI/3.0f,	// p[X( p )
		(float)SCREEN_WIDTH/SCREEN_HEIGHT,		// AXyNg
		1.0f,									// ONbv( 0 < Zn )0NG( Nbvʂ́AJǂꂾ̎E邩A܂0ɂƉZoO)
		1000.0f									// Nbv
		);

	// foCXɃvWFNVs̐ݒ
	pDevice ->SetTransform( D3DTS_PROJECTION, &mtxProj );

	
	/*// r[|[gϊ
	D3DVIEWPORT9 viewPort;

	static bool flag = false;
	if( GetKeyboardTrigger( DIK_SPACE ) ){
	
		if( flag ){
			flag = false;
		}else{
			flag = true;
		}
	}

	if( flag ){
		viewPort.X = 0;
	}else{
		viewPort.X = SCREEN_WIDTH >> 1;
	}
	viewPort.Y = 0;
	viewPort.Width  = SCREEN_WIDTH >> 1;
	viewPort.Height = SCREEN_HEIGHT>>1;
	viewPort.MinZ   = 0.0;
	viewPort.MaxZ   = 1.0; 

	// foCXɃr[|[g\̂ݒ
	pDevice ->SetViewport( &viewPort );
	*/

}

// CAMERA̐ݒ
void SetCamera( void )
{





}

// _̐ݒ
void SetLookAtView( const LPD3DXVECTOR3 lookAt )
{

	posAt = *lookAt;

}

// _̉]̎擾
D3DXVECTOR3 GetCameraRotation( void )
{

	return rotation;
	
}

// billboardps̎擾
D3DXMATRIX GetMtxView( void )
{

	return mtxViewInverse;

}

 




